# 🎨 نظام إدارة الوسائط - Media Management System

نظام متكامل لإدارة وعرض الصور والفيديوهات للمؤسسات بتصميم عصري مستوحى من Metronic 8.

## ✨ المميزات الرئيسية

### 🔐 نظام دخول مزدوج
- **لوحة تحكم إدارية**: للمسؤولين لإدارة المؤسسات والألبومات والوسائط
- **صفحة عرض للمؤسسات**: دخول آمن برمز خاص لكل مؤسسة

### 📁 إدارة متقدمة
- إضافة وتعديل وحذف المؤسسات
- إنشاء ألبومات مخصصة لكل مؤسسة
- رفع صور وفيديوهات متعددة
- تنظيم الوسائط حسب الألبومات
- صور غلاف للألبومات

### 🎯 واجهات مستخدم جميلة
- تصميم عصري مستوحى من Metronic 8
- دعم كامل للغة العربية (RTL)
- واجهات متجاوبة تعمل على جميع الأجهزة
- معرض صور تفاعلي مع Lightbox

### 🔒 الأمان
- حماية الصفحات بنظام الجلسات
- رموز دخول فريدة لكل مؤسسة
- تشفير كلمات المرور
- حماية من SQL Injection

## 📋 متطلبات التشغيل

- **PHP**: الإصدار 7.4 أو أحدث
- **MySQL**: الإصدار 5.7 أو أحدث
- **Apache**: مع mod_rewrite مفعل
- **المساحة**: 100 ميجابايت على الأقل

## 🚀 خطوات التثبيت

### 1️⃣ رفع الملفات
قم برفع جميع ملفات المشروع إلى مجلد على الخادم (مثل: `/var/www/html/media-system`)

### 2️⃣ إنشاء قاعدة البيانات

#### الطريقة الأولى: استخدام phpMyAdmin
1. افتح phpMyAdmin
2. انقر على "استيراد" (Import)
3. اختر ملف `database.sql`
4. انقر على "تنفيذ" (Go)

#### الطريقة الثانية: استخدام سطر الأوامر
```bash
mysql -u root -p < database.sql
```

### 3️⃣ تعديل إعدادات قاعدة البيانات
افتح ملف `config/database.php` وقم بتعديل البيانات التالية:

```php
define('DB_HOST', 'localhost');        // عنوان الخادم
define('DB_USER', 'root');             // اسم المستخدم
define('DB_PASS', '');                 // كلمة المرور
define('DB_NAME', 'media_management'); // اسم قاعدة البيانات
```

### 4️⃣ ضبط صلاحيات المجلدات
يجب أن تكون مجلدات الرفع قابلة للكتابة:

```bash
chmod -R 755 uploads/
chmod -R 755 uploads/images/
chmod -R 755 uploads/videos/
chmod -R 755 uploads/logos/
```

### 5️⃣ الوصول إلى النظام
افتح المتصفح واذهب إلى:
```
http://yourdomain.com/media-system/
```

## 👤 بيانات الدخول الافتراضية

### لوحة التحكم (Admin)
- **رابط الدخول**: `/admin/login.php`
- **اسم المستخدم**: `admin`
- **كلمة المرور**: `admin123`

⚠️ **مهم**: يُرجى تغيير كلمة المرور الافتراضية فوراً!

### المؤسسات التجريبية
تم إنشاء مؤسستين تجريبيتين:
1. **مؤسسة الأمل التعليمية** - رمز الدخول: `AMAL2024`
2. **مركز النور الثقافي** - رمز الدخول: `NOOR2024`

## 📚 دليل الاستخدام

### للمسؤولين

#### إضافة مؤسسة جديدة
1. سجل الدخول إلى لوحة التحكم
2. اذهب إلى "المؤسسات"
3. املأ النموذج:
   - اسم المؤسسة
   - رمز الدخول (يجب أن يكون فريداً)
   - الوصف (اختياري)
4. انقر على "إضافة"

#### إنشاء ألبوم
1. اذهب إلى "الألبومات"
2. اختر المؤسسة
3. أدخل عنوان الألبوم
4. ارفع صورة غلاف (اختياري)
5. انقر على "إضافة"

#### رفع وسائط
1. اذهب إلى "الوسائط"
2. اختر الألبوم المستهدف
3. اختر الملفات (يمكنك اختيار عدة ملفات)
4. أضف عنوان ووصف (اختياري)
5. انقر على "رفع الملفات"

### للمؤسسات

#### عرض الألبومات
1. اذهب إلى صفحة دخول المؤسسات
2. أدخل رمز الدخول الخاص بمؤسستك
3. ستظهر جميع الألبومات الخاصة بك

#### مشاهدة الوسائط
1. انقر على أي ألبوم
2. ستظهر جميع الصور والفيديوهات
3. انقر على أي صورة لعرضها بحجم كامل
4. استخدم الأسهم للتنقل بين الصور

## 🛠️ هيكل المشروع

```
media-system/
├── admin/                  # لوحة التحكم الإدارية
│   ├── login.php          # تسجيل دخول المسؤول
│   ├── index.php          # الصفحة الرئيسية
│   ├── institutions.php   # إدارة المؤسسات
│   ├── albums.php         # إدارة الألبومات
│   ├── media.php          # إدارة الوسائط
│   ├── header.php         # الهيدر المشترك
│   ├── footer.php         # الفوتر المشترك
│   └── logout.php         # تسجيل الخروج
├── client/                # واجهة المؤسسات
│   ├── login.php          # دخول المؤسسة
│   ├── gallery.php        # عرض الألبومات
│   ├── album.php          # عرض محتوى الألبوم
│   └── logout.php         # تسجيل الخروج
├── config/                # ملفات الإعدادات
│   └── database.php       # إعدادات قاعدة البيانات
├── includes/              # ملفات مساعدة
│   └── functions.php      # الدوال المشتركة
├── assets/                # الملفات الثابتة
│   ├── css/
│   │   └── style.css      # ملف التصميم الرئيسي
│   ├── js/
│   └── images/
├── uploads/               # مجلد الملفات المرفوعة
│   ├── images/           # الصور
│   ├── videos/           # الفيديوهات
│   └── logos/            # شعارات المؤسسات
├── database.sql          # ملف قاعدة البيانات
├── index.php             # الصفحة الرئيسية
├── .htaccess             # إعدادات Apache
└── README.md             # هذا الملف
```

## 🔧 تخصيص النظام

### تغيير الألوان
افتح ملف `assets/css/style.css` وعدل المتغيرات في بداية الملف:

```css
:root {
    --primary: #009EF7;    /* اللون الأساسي */
    --success: #50CD89;    /* لون النجاح */
    --danger: #F1416C;     /* لون الخطر */
    /* ... المزيد */
}
```

### تغيير حجم الرفع الأقصى
افتح ملف `includes/functions.php` وابحث عن السطر:

```php
if ($fileSize > 50 * 1024 * 1024) // 50MB
```

## 🐛 حل المشاكل الشائعة

### خطأ: "فشل رفع الملف"
- تأكد من صلاحيات مجلد `uploads/`
- تحقق من حجم الملف (الحد الأقصى 50 ميجابايت)
- راجع إعدادات PHP (`upload_max_filesize`, `post_max_size`)

### خطأ: "خطأ في الاتصال بقاعدة البيانات"
- تأكد من صحة بيانات الاتصال في `config/database.php`
- تحقق من أن خادم MySQL يعمل
- تأكد من أن المستخدم لديه صلاحيات على قاعدة البيانات

### الصور لا تظهر
- تحقق من المسارات في قاعدة البيانات
- تأكد من رفع الصور إلى المجلد الصحيح
- تحقق من صلاحيات القراءة للمجلدات

## 🔒 نصائح الأمان

1. **غيّر كلمة مرور الإدارة فوراً**
2. **استخدم رموز دخول قوية للمؤسسات**
3. **احتفظ بنسخة احتياطية من قاعدة البيانات**
4. **حدّث PHP و MySQL بانتظام**
5. **لا تعرض رسائل الأخطاء في الإنتاج**

## 📝 قاعدة البيانات

### الجداول الرئيسية

#### admins
- `id`: المعرف الفريد
- `username`: اسم المستخدم
- `password`: كلمة المرور المشفرة
- `full_name`: الاسم الكامل

#### institutions
- `id`: المعرف الفريد
- `name`: اسم المؤسسة
- `access_code`: رمز الدخول الفريد
- `description`: الوصف
- `is_active`: حالة التفعيل

#### albums
- `id`: المعرف الفريد
- `institution_id`: معرف المؤسسة
- `title`: عنوان الألبوم
- `description`: الوصف
- `cover_image`: صورة الغلاف
- `is_active`: حالة التفعيل

#### media
- `id`: المعرف الفريد
- `album_id`: معرف الألبوم
- `file_name`: اسم الملف
- `file_path`: مسار الملف
- `file_type`: نوع الملف (image/video)
- `file_size`: حجم الملف

## 🤝 الدعم والمساهمة

إذا واجهت أي مشاكل أو لديك اقتراحات للتحسين:
1. تحقق من قسم "حل المشاكل الشائعة"
2. راجع ملفات السجل (logs)
3. تأكد من استيفاء جميع المتطلبات

## 📄 الترخيص

هذا المشروع مفتوح المصدر ومتاح للاستخدام الشخصي والتجاري.

## 🎉 شكر خاص

- تصميم مستوحى من [Metronic 8](https://keenthemes.com/metronic/)
- خط Cairo من [Google Fonts](https://fonts.google.com/)

---

**تم التطوير بـ ❤️ للمجتمع العربي**

**الإصدار**: 1.0.0
**تاريخ الإصدار**: 2024
